/*
 * Decompiled with CFR 0.152.
 */
package com.outlyer.jmx.jmxquery;

import com.outlyer.jmx.jmxquery.ParseError;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularDataSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXMetric {
    private String metricName = null;
    private HashMap<String, String> metricLabels = new HashMap();
    private String mBeanName;
    private String attribute;
    private String attributeKey = null;
    private String attributeType = null;
    private Object value = null;

    public JMXMetric(String mBeanName, String attribute, String attributeKey) {
        this.mBeanName = mBeanName;
        this.attribute = attribute;
        this.attributeKey = attributeKey;
    }

    public JMXMetric(String metricQuery) throws ParseError {
        this.parseMetricQuery(metricQuery);
    }

    public String getmetricName() {
        return this.metricName;
    }

    public void setmetricName(String metricName) {
        this.metricName = metricName;
    }

    public HashMap<String, String> getmetricLabels() {
        return this.metricLabels;
    }

    public void setmetricLabels(HashMap<String, String> metricLabels) {
        this.metricLabels.clear();
        this.metricLabels.putAll(metricLabels);
    }

    public String getmBeanName() {
        return this.mBeanName;
    }

    public void setmBeanName(String mBeanName) {
        this.mBeanName = mBeanName;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public void setAttributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(Object value) {
        this.attributeType = value instanceof String ? "String" : (value == null ? "Null" : (value instanceof CompositeData ? "CompositeData" : (value instanceof TabularDataSupport ? "TabularDataSupport" : (value instanceof ObjectName ? "ObjectName" : (value instanceof Integer ? "Integer" : (value instanceof Long ? "Long" : (value instanceof Double ? "Double" : (value instanceof Boolean ? "Boolean" : value.getClass().getSimpleName()))))))));
    }

    public void replaceTokens() {
        if (this.metricName != null) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            if (this.attribute != null) {
                replacements.put("attribute", this.attribute);
            }
            if (this.attributeKey != null) {
                replacements.put("attributeKey", this.attributeKey);
            }
            int firstColon = this.mBeanName.indexOf(58);
            String[] props = this.mBeanName.substring(firstColon + 1).split("(?!\\B\"[^\"]*),(?![^\"]*\"\\B)");
            for (int i = 0; i < props.length; ++i) {
                String[] parts = props[i].split("=");
                replacements.put(parts[0], parts[1]);
            }
            this.metricName = this.replaceTokens(this.metricName, replacements);
            for (String key : this.metricLabels.keySet()) {
                String value = this.metricLabels.get(key);
                if (value.indexOf("}") <= 0) continue;
                value = this.replaceTokens(value, replacements);
                this.metricLabels.put(key, value);
            }
        }
    }

    private String replaceTokens(String text, HashMap<String, String> replacements) {
        Pattern pattern = Pattern.compile("\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(text);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            builder.append(text.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(text.substring(i, text.length()));
        return builder.toString().replaceAll("\"", "").replaceAll(" ", "_");
    }

    private void parseMetricQuery(String metricQuery) throws ParseError {
        try {
            String query = metricQuery;
            if (metricQuery.indexOf("==") > 0) {
                int seperator = metricQuery.indexOf("==");
                String metricNamePart = query.substring(0, seperator);
                query = query.substring(seperator + 2);
                if (metricNamePart.indexOf("<") > 0) {
                    int labelSeperator = metricNamePart.indexOf("<");
                    this.metricName = metricNamePart.substring(0, labelSeperator);
                    String labelsPart = metricNamePart.substring(labelSeperator + 1).replace(">", "");
                    String[] labels = labelsPart.split("(?!\\B\"[^\"]*),(?![^\"]*\"\\B)");
                    for (int i = 0; i < labels.length; ++i) {
                        String[] parts = labels[i].split("=");
                        if (parts.length < 2) {
                            throw new ParseError("Label format " + labelsPart + " is invalid.");
                        }
                        this.metricLabels.put(parts[0], parts[1]);
                    }
                } else {
                    this.metricName = metricNamePart;
                }
            }
            int firstColon = query.indexOf(58);
            String beanName = query.substring(0, firstColon + 1);
            query = query.substring(firstColon + 1);
            String[] paths = query.split("(?!\\B\"[^\"]*),(?![^\"]*\"\\B)");
            for (int i = 0; i < paths.length - 1; ++i) {
                beanName = beanName + paths[i] + ",";
            }
            query = paths[paths.length - 1];
            String[] parts = query.split("(?!\\B\"[^\"]*)/(?![^\"]*\"\\B)");
            this.mBeanName = beanName = beanName + parts[0];
            if (parts.length > 1) {
                this.attribute = parts[1];
            }
            if (parts.length > 2) {
                this.attributeKey = parts[2];
            }
        }
        catch (Exception e) {
            throw new ParseError("Error Parsing Metic Query: " + metricQuery, e);
        }
    }

    public String toString() {
        String s = "";
        if (this.metricName != null) {
            s = s + this.metricName + "<";
            int keyCount = 0;
            for (String key : this.metricLabels.keySet()) {
                s = s + key + "=" + this.metricLabels.get(key);
                if (++keyCount >= this.metricLabels.size()) continue;
                s = s + ",";
            }
            s = s + ">";
        } else {
            s = s + this.mBeanName;
            if (this.attribute != null) {
                s = s + "/" + this.attribute;
            }
            if (this.attributeKey != null) {
                s = s + "/" + this.attributeKey;
            }
        }
        if (this.attributeType != null) {
            s = s + " (" + this.attributeType + ")";
        }
        if (this.value != null) {
            s = s + " = " + this.value.toString();
        }
        return s;
    }

    public String toJSON() {
        String beanName = this.mBeanName.replace("\"", "\\\"");
        String json = "{";
        if (this.metricName != null) {
            json = json + "\"metricName\" : \"" + this.metricName + "\",";
            json = json + "\"metricLabels\" : {";
            int keyCount = 0;
            for (String key : this.metricLabels.keySet()) {
                json = json + "\"" + key + "\" : \"" + this.metricLabels.get(key) + "\"";
                if (++keyCount >= this.metricLabels.size()) continue;
                json = json + ",";
            }
            json = json + "},";
        }
        json = json + "\"mBeanName\" : \"" + beanName + "\"";
        json = json + ", \"attribute\" : \"" + this.attribute + "\"";
        if (this.attributeKey != null) {
            json = json + ", \"attributeKey\" : \"" + this.attributeKey + "\"";
        }
        if (this.attributeType != null) {
            json = json + ", \"attributeType\" : \"" + this.attributeType + "\"";
        }
        if (this.value != null) {
            json = this.value instanceof Integer || this.value instanceof Long || this.value instanceof Double || this.value instanceof Boolean ? json + ", \"value\" : " + this.value.toString() : json + ", \"value\" : \"" + this.value.toString() + "\"";
        }
        json = json + "}";
        return json;
    }
}

