/*
 * Decompiled with CFR 0.152.
 */
package com.outlyer.jmx.jmxquery;

import com.outlyer.jmx.jmxquery.JMXConnector;
import com.outlyer.jmx.jmxquery.JMXMetric;
import com.outlyer.jmx.jmxquery.ParseError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.management.MalformedObjectNameException;

public class JMXQuery {
    private JMXConnector connector;
    private final ArrayList<JMXMetric> metrics = new ArrayList();
    String url = null;
    String username = null;
    String password = null;
    boolean outputJSON = false;

    public static void main(String[] args) throws Exception {
        JMXQuery query = new JMXQuery();
        query.parse(args);
        try {
            query.connector = new JMXConnector(query.url, query.username, query.password);
        }
        catch (IOException ioe) {
            if (query.outputJSON) {
                System.out.println("{ \"error\": \"connection-error\", \"message\":\"" + ioe.getMessage() + "\"}");
                System.exit(2);
            }
            System.out.println("Error connecting to JMX endpoint: " + ioe.getMessage());
            System.exit(2);
        }
        try {
            ArrayList<JMXMetric> outputMetrics = query.connector.getMetrics(query.metrics);
            if (query.outputJSON) {
                System.out.println("[");
                int count = 0;
                for (JMXMetric metric : outputMetrics) {
                    metric.replaceTokens();
                    if (count > 0) {
                        System.out.print(", \n" + metric.toJSON());
                        continue;
                    }
                    ++count;
                    System.out.print(metric.toJSON());
                }
                System.out.println("]");
            } else {
                for (JMXMetric metric : outputMetrics) {
                    metric.replaceTokens();
                    System.out.println(metric.toString());
                }
                System.out.println("=====================");
                System.out.println("Total Metrics Found: " + String.valueOf(outputMetrics.size()));
            }
        }
        catch (IOException ioe) {
            if (query.outputJSON) {
                System.out.println("{ \"error\": \"query-connection-error\", \"message\":\"" + ioe.getMessage() + "\"}");
                System.exit(2);
            } else {
                System.out.println("There was an IO Error running the query '" + query.metrics.toString() + "': " + ioe.getMessage());
                System.exit(2);
            }
        }
        catch (MalformedObjectNameException me) {
            if (query.outputJSON) {
                System.out.println("{ \"error\": \"bad-query\", \"message\":\"" + me.getMessage() + "\"}");
                System.exit(2);
            } else {
                System.out.println("The query '" + query.metrics.toString() + "' is invalid: " + me.getMessage());
                System.exit(2);
            }
        }
        catch (Exception e) {
            if (query.outputJSON) {
                System.out.println("{ \"error\": \"general-exception\", \"message\":\"" + e.getMessage() + "\"}");
                System.exit(2);
            }
            System.out.println("An exception was thrown while running the query '" + query.metrics.toString() + "': " + e.getMessage());
            System.out.println(Arrays.toString(e.getStackTrace()));
            System.exit(2);
        }
        query.connector.disconnect();
    }

    private void includeJVMStats() {
        this.metrics.add(new JMXMetric("java.lang:type=ClassLoading", "LoadedClassCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=ClassLoading", "UnloadedClassCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=ClassLoading", "TotalLoadedClassCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=GarbageCollector,*", "CollectionTime", null));
        this.metrics.add(new JMXMetric("java.lang:type=GarbageCollector,*", "CollectionCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=Memory", "HeapMemoryUsage", "committed"));
        this.metrics.add(new JMXMetric("java.lang:type=Memory", "HeapMemoryUsage", "init"));
        this.metrics.add(new JMXMetric("java.lang:type=Memory", "HeapMemoryUsage", "max"));
        this.metrics.add(new JMXMetric("java.lang:type=Memory", "HeapMemoryUsage", "used"));
        this.metrics.add(new JMXMetric("java.lang:type=Memory", "NonHeapMemoryUsage", "committed"));
        this.metrics.add(new JMXMetric("java.lang:type=Memory", "NonHeapMemoryUsage", "init"));
        this.metrics.add(new JMXMetric("java.lang:type=Memory", "NonHeapMemoryUsage", "max"));
        this.metrics.add(new JMXMetric("java.lang:type=Memory", "NonHeapMemoryUsage", "used"));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "OpenFileDescriptorCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "MaxFileDescriptorCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "CommittedVirtualMemorySize", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "TotalSwapSpaceSize", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "FreeSwapSpaceSize", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "ProcessCpuTime", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "FreePhysicalMemorySize", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "TotalPhysicalMemorySize", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "SystemCpuLoad", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "ProcessCpuLoad", null));
        this.metrics.add(new JMXMetric("java.lang:type=OperatingSystem", "SystemLoadAverage", null));
        this.metrics.add(new JMXMetric("java.lang:type=Runtime", "Uptime", null));
        this.metrics.add(new JMXMetric("java.lang:type=Threading", "ThreadCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=Threading", "PeakThreadCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=Threading", "DaemonThreadCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=Threading", "TotalStartedThreadCount", null));
        this.metrics.add(new JMXMetric("java.lang:type=MemoryPool,*", "Usage", "committed"));
        this.metrics.add(new JMXMetric("java.lang:type=MemoryPool,*", "Usage", "init"));
        this.metrics.add(new JMXMetric("java.lang:type=MemoryPool,*", "Usage", "max"));
        this.metrics.add(new JMXMetric("java.lang:type=MemoryPool,*", "Usage", "used"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(String[] args) throws ParseError {
        try {
            int i = 0;
            while (true) {
                if (i >= args.length) {
                    if (this.url != null) return;
                    if (this.metrics.size() <= 1) return;
                    System.out.println("Required options not specified.");
                    this.printHelp(System.out);
                    System.exit(0);
                    return;
                }
                String option = args[i];
                if (option.equals("-help") || option.equals("-h")) {
                    this.printHelp(System.out);
                    System.exit(0);
                } else if (option.equals("-url")) {
                    this.url = args[++i];
                } else if (option.equals("-username") || option.equals("-u")) {
                    this.username = args[++i];
                } else if (option.equals("-password") || option.equals("-p")) {
                    this.password = args[++i];
                } else if (option.equals("-query") || option.equals("-q")) {
                    String[] query;
                    for (String metricQuery : query = args[++i].split(";")) {
                        this.metrics.add(new JMXMetric(metricQuery));
                    }
                } else if (option.equals("-json")) {
                    this.outputJSON = true;
                } else if (option.equals("-incjvm")) {
                    this.includeJVMStats();
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ParseError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printHelp(PrintStream out) {
        InputStream is = JMXQuery.class.getClassLoader().getResourceAsStream("com/outlyer/jmx/jmxquery/HELP");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                out.println(s);
            }
        }
        catch (IOException e) {
            out.println(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                out.println(e);
            }
        }
    }
}

