/*
 * Decompiled with CFR 0.152.
 */
package com.outlyer.jmx.jmxquery.tools;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.Properties;

public class LocalJMXConnection {
    private String displayName = "";
    private String id = "";
    private String jmxUrl = null;

    public LocalJMXConnection(VirtualMachineDescriptor desc) throws AttachNotSupportedException, IOException {
        VirtualMachine vm = VirtualMachine.attach(desc);
        Properties props = vm.getAgentProperties();
        this.displayName = desc.displayName().split(" ")[0];
        this.id = desc.id();
        this.jmxUrl = props.getProperty("com.sun.management.jmxremote.localConnectorAddress");
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public String toString() {
        return this.displayName + " (" + this.id + "): " + this.jmxUrl;
    }

    public String toJSON() {
        String json = "{";
        json = json + "\tdisplayname: " + this.displayName + ",\n";
        json = json + "\tid: " + this.id + ",\n";
        json = json + "\turl: " + this.jmxUrl + ",\n";
        json = json + "}";
        return json;
    }
}

