#!/usr/bin/python
# coding: utf-8

import os, sys, public

_title = '检查tmp目录下是否存在异常木马文件'
_version = 1.0  # 版本
_ps = "检查tmp目录下是否存在异常木马文件"  # 描述
_level = 3  # 风险级别： 1.提示(低)  2.警告(中)  3.危险(高)
_date = '2023-11-22'  # 最后更新时间
_ignore = os.path.exists("data/warning/ignore/sw_tmp_malware.pl")
_tips = [
    "根据描述删除检测到的异常木马文件",
]
_help = ''
_remind = '该文件符合木马文件的特征，建议删除并重装nginx服务器，对服务器进行全面的安全检查'


def check_run():
    '''
        @name 开始检测
        @author lwh<2023-11-22>
        @return tuple (status<bool>,msg<string>)
    '''
    list1 = ['/var/tmp/systemd-private-56d86f7d8382402517f3b51625789161d2cb-chronyd.service-jP37av','/var/tmp/systemd-private-56d86f7d8382402517f3b5-jP37av','/tmp/systemd-private-56d86f7d8382402517f3b5-jP37av','/var/tmp/count','/var/tmp/count.txt','/var/tmp/backkk','/var/tmp/msglog.txt']
    risk_file = []
    for filename in list1:
        if not os.path.exists(filename):
            continue
        if os.path.isdir(filename):
            continue
        risk_file.append(filename)
    if len(risk_file) > 0:
        return False, '检测到异常木马文件，请尽快删除：{}'.format('、'.join(risk_file))
    return True, '无风险'
